---
name: knowd
description: Personal knowledge base — save web pages and search them semantically. Use when user shares a URL to save/bookmark/remember, asks "what did I save about...", wants to search saved articles, or asks about their knowledge base. Supports multiple embedding providers (OpenAI, Voyage, Cohere, Jina, Ollama).
metadata: {"clawdbot": {"emoji": "🧠", "requires": {"bins": ["python3"]}, "primaryEnv": "OPENAI_API_KEY"}}
---

# knowd — Personal Knowledge Base

Save web pages, search them semantically. No UI — just conversation.

## Setup

Install dependencies:
```bash
pip3 install -r <skill>/requirements.txt
```

Set ONE of these API keys (or use Ollama for local/free):
- `OPENAI_API_KEY` — OpenAI text-embedding-3-small (default)
- `VOYAGE_API_KEY` — Voyage AI voyage-3-lite
- `COHERE_API_KEY` — Cohere embed-v4
- `JINA_API_KEY` — Jina jina-embeddings-v3
- Ollama: no key needed, just have Ollama running locally

The provider is locked in on first save — can't mix embedding spaces in the same DB.

## Commands

```bash
# Save a URL
python3 <skill>/scripts/knowd.py save "<url>"

# Save with a specific provider (first use only sets the provider)
python3 <skill>/scripts/knowd.py --provider voyage save "<url>"

# Semantic search
python3 <skill>/scripts/knowd.py search "<query>" -k 5

# List saved sources
python3 <skill>/scripts/knowd.py list

# Stats (includes provider info)
python3 <skill>/scripts/knowd.py stats

# Delete a source
python3 <skill>/scripts/knowd.py delete "<url-or-id>"

# List available providers and which keys are set
python3 <skill>/scripts/knowd.py providers
```

## When to Use

### Saving
When user shares a URL with intent to save ("save this", "remember this", "bookmark this", "add to my knowledge base"):
1. Run `knowd save "<url>"`
2. Report: title, chunk count, provider used
3. Be conversational: "Saved! Got 8 chunks from 'Article Title' via openai."

### Searching
When user asks about saved knowledge ("what did I save about...", "find that article about...", "search my knowledge base for..."):
1. Run `knowd search "<query>"`
2. Summarize results naturally — titles, relevant snippets, scores only if helpful
3. Don't dump raw output; synthesize

### Listing
When user asks what they've saved:
1. Run `knowd list`
2. Present as a clean list with titles and dates

### Provider Selection
- On first use, if user hasn't specified, auto-detect: use whichever API key is available in the environment
- If multiple keys exist, prefer OpenAI (most common)
- If user explicitly requests a provider: `--provider cohere`
- After first save, the provider is locked to that DB

## State

Database: `<workspace>/state/knowd.db` (SQLite)

The DB stores the embedding provider/model in metadata. Attempting to use a different provider on an existing DB will error with a clear explanation.

## Auto-Detection

If the user doesn't specify a provider, check environment variables in this order:
1. OPENAI_API_KEY → openai
2. VOYAGE_API_KEY → voyage  
3. COHERE_API_KEY → cohere
4. JINA_API_KEY → jina
5. Check if Ollama is running → ollama
6. Error: no provider available
