# Question Framework by Style

## Exploratory Style Questions

Focus on helping them discover their own answers.

### Opening
- "What's really at the heart of this for you?"
- "Why does this matter right now?"
- "What would success look like?"

### Exploration
- "What assumptions are you making that might not be true?"
- "What would have to be true for this to work?"
- "What are you avoiding thinking about?"
- "If you couldn't do it this way, what would you do?"
- "What's the fear underneath this decision?"
- "What would [someone you respect] tell you?"

### Synthesis
- "So what I'm hearing is... does that resonate?"
- "What's the single most important thing here?"
- "What would you tell a friend in this situation?"
- "If you had to decide right now, what would you choose?"

### Commitment
- "What are you ready to commit to?"
- "What might derail you, and how will you handle it?"

### Adaptive Patterns
- **When excited**: Follow that thread. "What excites you most about this?"
- **When uncertain**: Don't rush. "What would help you feel more confident?"
- **When stuck**: Change perspective. "What would you tell a friend in this situation?"
- **When avoiding**: Name it gently. "I notice you haven't mentioned X. Is that intentional?"
- **When overwhelmed**: Simplify. "If you could only do one thing, what would it be?"

---

## Structured Style Questions

Systematic coverage of all aspects.

### The Basics (Who/What/When/Where/Why/How)
- Who is involved or affected?
- What specifically needs to happen?
- When does this need to happen by?
- Where does this take place?
- Why is this important?
- How will you approach it?

### Constraints & Requirements
- What are the non-negotiables?
- What's the budget or resources available?
- What dependencies exist?
- What could block progress?
- What trade-offs are you willing to make?

### Success & Completion
- How will you know it's done?
- What does success look like?
- Who needs to approve or sign off?
- What metrics matter?

### Risks & Contingencies
- What could go wrong?
- What's your backup plan?
- What's the worst case scenario?
- What would you do if [X] happened?

---

## Rapid-fire Style Questions

Quick extraction of essentials.

### Core Questions (pick 5-7 based on topic)
- What's the goal?
- Who's it for?
- When do you need it?
- What's blocking you?
- What's the budget?
- What's non-negotiable?
- What's the first step?
- How will you know it worked?
- What's the one thing that matters most?
- What's already decided?

### Style Notes
- Keep questions short (under 10 words ideal)
- Accept brief answers - don't probe
- Move quickly through the list
- Focus on capturing, not exploring
- If they give long answers, that's fine - but don't ask follow-ups
- Skip questions if the answer is obvious from context

---

## Universal Patterns

### When to Use AskUserQuestion Tool
- At branching points where the answer significantly changes direction
- When offering multiple valid approaches
- When you need explicit choice between options

### When to Use Open Questions (Plain Text)
- For probing deeper into an answer
- For "why" and "what if" questions
- For reflecting back what you heard
- For exploring emotions or values

### Ending the Interview
Always end with:
1. A brief synthesis of what you heard
2. Confirmation that you captured it correctly
3. The structured output deliverable
